/*---------------------------------------------------------------------
   8031/51OWIIC1602 LCD
   LCM1602 + PCF8574T I2C 
   ѦҺ}G
   https://startfromgarage.blogspot.com/2018/09/8051i2clcdlcm1602.html

   2024/02/04
------------------------------------------------------------------------*/
#include "reg52.h"

sbit sda = P1^0;
sbit scl = P1^1;

#define SLAVE 0x4E   //LCM1602 IIC}wq

void delay(unsigned int dl){
  while (dl>0)
  dl--;
}

void delay_ms(long ms){
  long i;
	for(i=0; i<=20*ms; i++)
	  ;
}

void start(){
  scl = 1;
  delay(5);
  sda = 1;
  delay(5);
  sda = 0;
  delay(4);
}

void send_8bits(unsigned char strg){
  unsigned char sf;
  for (sf=0; sf<8; sf++)
  {
    scl = 0;
    sda =(bit)(strg & (0x80>>sf));
    delay(5);
    scl = 1;
    delay(4);
  }
  scl = 0;
  delay(5);
}

void ack(void){
  sda = 1; 
  if(sda == 0)
  {  
    scl = 1;
    delay(4);
    scl = 0;
    delay(5);
  }
}
/*
void stop(void){
  sda = 0;
  scl = 1;
  delay(5);
  sda = 1;
}
*/
void WriteInst4bits(unsigned char inst_4b){
  send_8bits(0x08);         //RS=0, RW=0
  ack();
  send_8bits(0x0C);         //EN=1
  ack();
  send_8bits((inst_4b&0xF0)+0x0C); //eXD7-D4
  ack();
  send_8bits((inst_4b&0xF0)+0x08); //EN=0 Ū|줸
  ack();
}

void WriteInst(unsigned char inst){ 
  send_8bits(0x08);         //RS=0, RW=0
  ack();
  send_8bits(0x0C);         //EN=1
  ack();
  send_8bits((inst&0xF0)+0x0C);   //|
  ack();
  send_8bits((inst&0xF0)+0x08);   //EN=0 Ū|
  ack();
 
  send_8bits(0x0C);         //EN=1
  ack();
  send_8bits((inst<<4)+0x0C);    //C|
  ack();
  send_8bits((inst<<4)+0x08);    //EN=0 ŪC|
  ack();
} 

void WriteData(unsigned char data_){
  send_8bits(0x09);         //RS=1, RW=0
  ack();
  send_8bits(0x0D);         //EN=1
  ack();
  send_8bits((data_&0xF0)+0x0D);  //|
  ack();
  send_8bits((data_&0xF0)+0x09);  //EN=0 Ū|
  ack();
 
  send_8bits(0x0D);         //EN=1
  ack();
  send_8bits((data_<<4)+0x0D);   //C|
  ack();
  send_8bits((data_<<4)+0x09);   //EN=0 ŪC|
  ack();
} 
 
void WriteString(unsigned char count, unsigned char MSG[]){
  unsigned char sf;
  unsigned char move = 0;
  for (sf=0; sf<count; sf++)
    WriteData(MSG[sf]);
}

void ClearLCD(void){
  WriteInst(0x80);  //]wDDRAM}ܦm(Ĥ@1)
	WriteString(sizeof("                ")-1, "                ");
	WriteInst(0xC0);  //]wDDRAM}ܦm(ĤG3)
	WriteString(sizeof("                ")-1,"                ");
}

void initial(void){
  delay(15000);
 
  start();
  send_8bits(SLAVE);  //ǰeLCM1602}
  ack();
 
  WriteInst4bits(0x30); //gJ0011DB7-4
 
  delay(4100);
 
  WriteInst4bits(0x30); //gJ0011DB7-4
 
  delay(100);

  WriteInst4bits(0x30); //gJ0011DB7-4
  WriteInst4bits(0x20); //gJ0010DB7-4
  
  WriteInst(0x28); //\]w function set, DL(DB4)=0(4줸ǿ), N(DB3)=1(2C), F(DB2)=0(5*7ѪR)
  WriteInst(0x08); //ù display off
  WriteInst(0x01); //Mù clear display
  WriteInst(0x06); //ʼҦ entry mode
  WriteInst(0x0E); //}ҿù display ON, D(DB2)=1(}), C(DB1)=1(ж}), B(DB0)=0({{)
}

void main()
{
  unsigned char MSG_3[] = "LCD test running";
  unsigned char MSG_4[] = "Orion Liu ";
  
  initial();
  
  while(1){	 
    //Ĥ@ؤ覡AeܼưOŶAr
    WriteInst(0x80);  //]wDDRAM}ܦm(Ĥ@1)
	  WriteString(sizeof("Start the 8051")-1, "Start the 8051");  
	  WriteInst(0xC3);  //]wDDRAM}ܦm(ĤG3)
	  WriteString(sizeof("Hello World! ")-1, "Hello World! ");
	  delay_ms(1000);
	  ClearLCD();
	 
    //ĤGؤ覡ArbܼƸ
	  WriteInst(0x80);  //]wDDRAM}ܦm(Ĥ@1)
	  WriteString(sizeof(MSG_3)-1, MSG_3);
	  WriteInst(0xC0);  //]wDDRAM}ܦm(ĤG3)
	  WriteString(sizeof(MSG_4)-1, MSG_4);
	  delay_ms(1000);
	  ClearLCD();
  }
}
